/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.projectile.LOTREntityThrownRock2;
import lotr.common.fac.LOTRFaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityMountainSnowTroll
extends LOTREntityTroll {
    public static IAttribute thrownRockDamage = new RangedAttribute("lotr.thrownRockDamage", 5.0, 0.0, 100.0).func_111117_a("LOTR Thrown Rock Damage");
    private EntityAIBase rangedAttackAI = this.getTrollRangedAttackAI();
    private EntityAIBase meleeAttackAI;

    public LOTREntityMountainSnowTroll(World world) {
        super(world);
        this.isChilly = true;
        this.isImmuneToFrost = true;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.GUNDABAD;
    }

    @Override
    public float getTrollScale() {
        return 1.6f;
    }

    @Override
    public EntityAIBase getTrollAttackAI() {
        this.meleeAttackAI = new LOTREntityAIAttackOnCollide(this, 1.8, false);
        return this.meleeAttackAI;
    }

    protected EntityAIBase getTrollRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.2, 30, 60, 24.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public boolean isThrowingRocks() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public void setThrowingRocks(boolean flag) {
        this.field_70180_af.func_75692_b(21, (Object)(flag ? (byte)1 : 0));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)MathHelper.func_76136_a((Random)this.field_70146_Z, (int)70, (int)80));
        this.func_110148_a(npcAttackDamage).func_111128_a(9.0);
        this.func_110148_a(npcAttackDamageExtra).func_111128_a(1.1);
        this.func_110140_aT().func_111150_b(thrownRockDamage);
    }

    @Override
    protected boolean hasTrollName() {
        return false;
    }

    @Override
    protected boolean canTrollBeTickled(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public double getMeleeRange() {
        return 12.0;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.setThrowingRocks(false);
        }
        if (mode == LOTREntityNPC.AttackMode.MELEE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(3, this.meleeAttackAI);
            this.setThrowingRocks(false);
        }
        if (mode == LOTREntityNPC.AttackMode.RANGED) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(3, this.rangedAttackAI);
            this.setThrowingRocks(true);
        }
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        EntityArrow template = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, f * 1.5f, 0.5f);
        LOTREntityThrownRock2 rock = this.getThrownRock();
        rock.func_70012_b(template.field_70165_t, template.field_70163_u, template.field_70161_v, template.field_70177_z, template.field_70125_A);
        rock.field_70159_w = template.field_70159_w;
        rock.field_70181_x = template.field_70181_x + 0.6;
        rock.field_70179_y = template.field_70179_y;
        this.field_70170_p.func_72838_d((Entity)rock);
        this.func_85030_a(this.func_70639_aQ(), this.func_70599_aP(), this.func_70647_i() * 0.75f);
        this.func_71038_i();
    }

    protected LOTREntityThrownRock2 getThrownRock() {
        LOTREntityThrownRock2 rock = new LOTREntityThrownRock2(this.field_70170_p, (EntityLivingBase)this);
        rock.setDamage((float)this.func_110148_a(thrownRockDamage).func_111126_e());
        return rock;
    }

    @Override
    public void onTrollDeathBySun() {
        this.field_70170_p.func_72956_a((Entity)this, "lotr:troll.transform", this.func_70599_aP(), this.func_70647_i());
        this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        this.func_70106_y();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            super.func_70103_a(b);
            for (int l = 0; l < 64; ++l) {
                LOTRMod.proxy.spawnParticle("largeStone", this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int totemChance = 15 - i * 3;
        totemChance = Math.max(totemChance, 1);
        if (this.field_70146_Z.nextInt(totemChance) == 0) {
            this.func_70099_a(new ItemStack(LOTRMod.trollTotem, 1, this.field_70146_Z.nextInt(3)), 0.0f);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killMountainSnowTroll;
    }

    @Override
    public float getAlignmentBonus() {
        return 4.0f;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 7 + this.field_70146_Z.nextInt(6);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        return null;
    }
}

